/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.values;

import java.util.Vector;
import org.w3c.css.values.CssOperator;
import org.w3c.css.values.CssValue;

public class CssExpression
implements CssOperator {
    private Vector<ValueOperator> items = new Vector();
    private int count = 0;
    private int index = 0;

    public void addValue(CssValue value) {
        this.items.addElement(new ValueOperator(value));
        ++this.count;
    }

    public void setOperator(char operator) {
        this.items.elementAt((int)(this.count - 1)).operator = operator;
    }

    public void setCurrentOperator(char operator) {
        this.items.elementAt((int)this.index).operator = operator;
    }

    public CssValue getValue() {
        if (this.index == this.count) {
            return null;
        }
        return this.items.elementAt((int)this.index).value;
    }

    public CssValue getNextValue() {
        if (this.index + 1 >= this.count) {
            return null;
        }
        return this.items.elementAt((int)(this.index + 1)).value;
    }

    public char getOperator() {
        if (this.index == this.count) {
            return ' ';
        }
        return this.items.elementAt((int)this.index).operator;
    }

    public int getCount() {
        return this.count;
    }

    public void insert(CssValue value) {
        this.items.insertElementAt(new ValueOperator(value), this.index);
        ++this.count;
    }

    public void remove() {
        if (this.index != this.count) {
            this.items.removeElementAt(this.index);
        }
        --this.count;
    }

    public boolean end() {
        return this.index == this.count;
    }

    public void starts() {
        this.index = 0;
    }

    public void ends() {
        this.index = this.count;
    }

    public void next() {
        if (this.index < this.count) {
            ++this.index;
        }
    }

    public void precedent() {
        if (this.index > 0) {
            --this.index;
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (int i = this.index; i < this.count; ++i) {
            ValueOperator vo = this.items.elementAt(i);
            sb.append(vo.value.toString()).append(vo.operator);
        }
        if (sb.length() > 0) {
            return sb.deleteCharAt(sb.length() - 1).toString();
        }
        return "**invalid state**";
    }

    public String toStringFromStart() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.index; ++i) {
            ValueOperator vo = this.items.elementAt(i);
            sb.append(vo.value.toString()).append(vo.operator);
        }
        return sb.toString();
    }

    class ValueOperator {
        CssValue value;
        char operator;

        ValueOperator(CssValue value) {
            this.value = value;
            this.operator = (char)32;
        }
    }
}

